import 'package:admin_desktop/application/main/main_notifier.dart';
import 'package:admin_desktop/application/main/main_state.dart';
import 'package:admin_desktop/infrastructure/services/tr_keys.dart';
import 'package:flutter/material.dart';
import 'package:remixicon_updated/remixicon_updated.dart';

import 'navigation_item.dart';

class CustomMasterBottomBar extends StatelessWidget {
  final MainState state;
  final MainNotifier notifier;

  const CustomMasterBottomBar({
    super.key,
    required this.state,
    required this.notifier,
  });

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
      children: [
        NavigationItem(
          selectIcon: Remix.calendar_todo_fill,
          icon: Remix.calendar_todo_line,
          onTap: () => notifier.changeIndex(0),
          isActive: state.selectIndex == 0,
          title: TrKeys.schedule,
          titleActive: state.active,
        ),
        NavigationItem(
          selectIcon: Remix.pie_chart_fill,
          icon: Remix.pie_chart_line,
          onTap: () => notifier.changeIndex(1),
          title: TrKeys.statistics,
          isActive: state.selectIndex == 1,
          titleActive: state.active,
        ),
        NavigationItem(
          selectIcon: Remix.pie_chart_fill,
          icon: Remix.pie_chart_line,
          onTap: () => notifier.changeIndex(3),
          title: TrKeys.services,
          isActive: state.selectIndex == 3,
          titleActive: state.active,
        ),
      ],
    );
  }
}
